<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CComments extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == "comments") {
			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("comments");

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			
			switch ($sub) {
				case "landing":
					$sub = "comments";
				case "comments":

					$this->plugins["dashboard"]->UpdateModuleAction($this->tpl_module["module_id"]);
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;

				case "settings":
					urlredirect("index.php?mod=modules&sub=default&action=details&module_id={$this->tpl_module[module_id]}&t=u");
				break;

				case "action.delete":
					if (is_array($_POST["comment_id"])) {
						$this->db->Query(
							"DELETE FROM {$this->tables['plugin:comments']} WHERE comment_id IN (" . implode("," , $_POST["comment_id"]). ")"
						);
					}
					return "1";					
				break;

				case "action.spam":
					$this->db->Query(
						"DELETE FROM {$this->tables['plugin:comments']} WHERE comment_status=3"
					);
					return "1";					
				break;

				case "action.approve":
					if (is_array($_POST["comment_id"])) {
						$this->db->Query(
							"UPDATE {$this->tables['plugin:comments']} SET comment_status=2 WHERE comment_id IN (" . implode("," , $_POST["comment_id"]). ")"
						);
					}

					return "1";
					
				break;

			}
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DashboardWidgets($mod= null) {
		global $base , $_CONF;

		$module = $this->module->plugins["modules"]->LoadDefaultModule("comments");

		if (!$module["module_status"]) {
			return "";
		}

		if (!$base->acl->checkModRule($module , "local.list")) {
			return "";
		}

		

		$_CONF["forms"]["adminpath"] = _MODPATH . "comments/forms/";
		$latest = new CSQLAdmin("dashboard/latest", $this->__parent_templates,$this->db,$this->tables,$extra);
		$content = $latest->DoEvents();
//		if (!(stristr($content , "No available records."))) {
			return array(
				array(
					"width"	=> "6",
					"type"	=> "widget",
					"pos"	=> "1",
					"body"	=> $content
				),
			);
//		}
	}





	function DashboardNumbers($module) {
		global $_SESS , $base;

		$module = $this->module->plugins["modules"]->LoadDefaultModule("comments");

		if (!$module["module_status"]) {
			return "";
		}

		if (!$base->acl->checkModRule($module , "local.list")) {
			return "";
		}

		

		if (is_array($module)) {

			return array(
				array(
					"skin"		=> "Lilac",
					"icon"		=> "comments",
					"link"		=> "index.php?mod=comments&sub=landing",
					"count"		=> $this->db->RowCount($this->tables['plugin:comments'], "WHERE comment_status=1 AND comment_date > " . $this->plugins["dashboard"]->GetAccessDate($module["module_id"])),
					"title"		=> "New Comments",
					"subtitle"	=> $module["module_name"],
				),
			);

		}
	}

	/**
	* description used for installers
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetCommentsWidget() {
		$widget = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:widgets']} WHERE widget_type LIKE 'ccommentswidgetcomments' LIMIT 1" );
		return $widget["widget_id"];
	}
	
}

?>